SUBROUTINE ponto_medio(x, f, n, integral)
    !Calcula a integral de uma função (y(x)) pelo método do ponto médio

    IMPLICIT NONE

    DOUBLE PRECISION, DIMENSION(n) :: x, f !Arrays com abscissas x e ordenadas f(x)
    DOUBLE PRECISION :: h, fm, integral !Tamanho dos subintervalos, valor médio da função no intervalo considerado, valor da integral calculada
    INTEGER :: n, i !Dimensão de x e f, variável auxiliar
    
    !Definindo variável integral
    integral = 0.
    
    !Calculando a integral
    DO i = 1, (n-1)

        h = x(i+1) - x(i)
        fm = (f(i) + f(i+1)) / 2
        
        integral = integral + h * fm
    
    END DO

END SUBROUTINE ponto_medio

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

PROGRAM line_width
    !Determina a largura equivalente de uma linha espectral

    IMPLICIT NONE
    
    DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: lbd, flux, f !Arrays de comprimentos de onda, fluxo e função a ser integrada
    DOUBLE PRECISION :: width !Valor da largura e função a ser integrada
    INTEGER :: n, i, IOstatus !Variáveis auxiliares
    
    !DEFININDO LBD E F
    n = 0
    
    !Abre o arquivo com os dados de comprimento de onda e fluxo
    OPEN(UNIT=1, FILE="halpha.txt", STATUS="OLD", ACTION="READ")
    
    DO
        !Lê uma linha e verifica se não está vazia (VAZIA: IOstatus < 0)
        READ(UNIT=1, FMT=*, IOSTAT=IOstatus)
        
        IF (IOstatus .EQ. 0) THEN
        
            !Incrementa o valor de n
            n = n + 1
        
        ELSE
            EXIT
            
        END IF
    
    END DO
    
    !Fecha o arquivo
    CLOSE(UNIT=1)
    
    !Aloca um espaço n de memória nos arrays lbd, flux e f
    ALLOCATE(lbd(n), flux(n), f(n))
    
    !Abre novamente o arquivo
    OPEN(UNIT=1, FILE="halpha.txt", STATUS="OLD", ACTION="READ")
    
    !Forma os arrays lbd e flux
    DO i = 1, n
    
        !Lê uma linha e adiciona os dados nos respectivos arrays
        READ(UNIT=1, FMT=*) lbd(i), flux(i)
        
    END DO
    
    !Definindo f(x)
    f = 1 - flux
    
    !Fecha o arquivo de input
    CLOSE(UNIT=1)
    
    !CALCULA A LARGURA
    CALL ponto_medio(lbd, f, n, width)
    
    PRINT *, "A largura equivalente da linha é:", width

END PROGRAM line_width
